#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

// hlsl funkce lit (zhruba)
vec4 lit (float ndotl, float ndoth, float m)
{
	vec4 result = vec4(0.0, 0.0, 0.0, 1.0);
	
	result.r = 1.0;
	result.g = max(0.0, ndotl);
	if (ndotl > 0.0)
		result.b = pow(max(0.0, ndoth), m);
	
	return result;
}
	
uniform sampler2D color_map1;

#ifndef SIMPLE
uniform sampler2D specular_map1;
uniform vec4 camera_position;
uniform float  sharpen;
uniform float  shine;
uniform float  specularMult;
uniform vec4 light_specular;
#endif

uniform sampler2D overlay_map;
uniform sampler2D cloud_map;

uniform vec4 light_ambient;
uniform vec4 surface_ambient_colour;
uniform vec4 surface_diffuse_colour;
uniform vec4 light_position;
uniform vec4 light_diffuse;

#ifdef TWO_TEXTURES
	uniform sampler2D color_map2;
	#ifndef SIMPLE
	uniform sampler2D specular_map2;
	#endif
#endif

varying vec4 _colour;
varying vec4 _uv0;
varying vec4 _uv1;
varying vec4 _uv2;
varying vec4 _world_position;
varying vec4 _world_normal;

void main()
{
	vec4 result;
	vec4 color_diffuse;
	vec4 color_specular;
	vec4 cloud;
	vec4 overlay;
	vec4 lighting;
	vec3 light_direction;
	vec3 diffuse;
	#ifndef SIMPLE
	vec3 camera_direction;
	vec3 halfVec;
	vec3 specular;
	float depth;
	#endif
	
	#ifdef TWO_TEXTURES
		vec4 color_base;
		vec4 specular_base;
		vec4 color_top;
		vec4 specular_top;
		
		color_base =    texture2D(color_map1,    _uv0.xy);
		color_top =     texture2D(color_map2,    _uv0.xy);
		
		#ifndef SIMPLE
		color_base -=   texture2D(color_map1,    _uv0.xy + 0.0001) * sharpen;
		color_base +=   texture2D(color_map1,    _uv0.xy - 0.0001) * sharpen;
		color_top -=    texture2D(color_map2,    _uv0.xy + 0.0001) * sharpen;
		color_top +=    texture2D(color_map2,    _uv0.xy - 0.0001) * sharpen;
		
		specular_base = texture2D(specular_map1, _uv0.xy);
		specular_top =  texture2D(specular_map2, _uv0.xy);
		#endif
		
		color_diffuse =  mix(color_base,    color_top,    _colour.a);
		color_specular = mix(specular_base, specular_top, _colour.a);
		
	#else // one texture
	
		color_diffuse =  texture2D(color_map1, _uv0.xy);
		
		#ifndef SIMPLE
		color_diffuse -= texture2D(color_map1, _uv0.xy + 0.0001) * sharpen;
		color_diffuse += texture2D(color_map1, _uv0.xy - 0.0001) * sharpen;
		color_specular = texture2D(specular_map1, _uv0.xy);
		#endif
	#endif
	
	cloud =   texture2D(cloud_map,   _uv1.xy);
	overlay = texture2D(overlay_map, _uv2.xy);
	
	color_diffuse.rgb *= cloud.rgb;
	color_diffuse.rgb *= pow(overlay.rgb, vec3(2.0));
	
	// znasilni barevnou slozku textury
	color_diffuse.rgb = clamp(color_diffuse.rgb * 1.1 - 0.05, 0.0, 1.0);
	
	// znasilni alfu
	#ifdef MODULATE_ALPHA
		color_diffuse.a = clamp(color_diffuse.a * 2.0, 0.0, 1.0);
	#endif
	
	#ifndef SIMPLE
		camera_direction = camera_position.xyz - _world_position.xyz;
		depth = length(camera_direction);
	camera_direction /= depth;
	#endif
	
	light_direction = light_position.xyz - (_world_position.xyz * light_position.w);
	
	#ifndef SIMPLE
		halfVec = normalize(light_position.xyz + camera_direction);
		lighting = lit(dot(light_direction, _world_normal.xyz), dot(halfVec, _world_normal.xyz), shine);
	#else
		lighting = lit(dot(light_direction, _world_normal.xyz), 0.0, 1.0);
	#endif
	
	// trochu znasilni difuzni cast osvetleni
	lighting.y = lighting.y * 1.1 - 0.05;
	
	diffuse  = lighting.y * light_diffuse.rgb;
	#ifndef SIMPLE
	specular = lighting.z * light_specular.rgb * color_specular.rgb * specularMult;
	#endif
	
	result.rgb = color_diffuse.rgb * _colour.rgb * clamp(light_ambient.rgb * surface_ambient_colour.rgb + diffuse, 0.0, 1.0);
	result.a = color_diffuse.a * _colour.a * surface_diffuse_colour.a;
	#ifndef SIMPLE
		result.rgb += specular;
	#endif
	#ifdef TWO_TEXTURES
		result.a = surface_diffuse_colour.a;
	#endif
	
	gl_FragColor = result;
}

