#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform mat4 world_view_proj;
uniform mat4 world;

attribute vec4 vertex;
attribute vec3 normal;

varying vec4 _world_position;
varying vec4 _world_normal;

void main()
{
	_world_position = world * vertex;
	_world_normal = normalize((world * vec4(normal, 0)));
	
	gl_Position = world_view_proj * vertex;
}

