#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

//#define SIMPLE=1
//#define PERVERTEX 1

#ifdef TEXBLEND
	#define TWOTEXTURES 1
#endif
#ifdef LEAVES
	#define TWOTEXTURES 1
#endif
#ifndef PERVERTEX
	#define PERPIXEL 1
#endif

// hlsl funkce lit (zhruba)
vec4 lit (in float ndotl, in float ndoth, in float m)
{
	vec4 result = vec4(0.0, 0.0, 0.0, 1.0);
	
	result.r = 1.0;
	result.g = max(0.0, ndotl);
#ifdef SPECULAR
	if (ndotl > 0.0)
		result.b = pow(max(0.0, ndoth), m);
#endif
	return result;
}

uniform sampler2D color_map1;

#ifdef PERPIXEL
	uniform vec4   surface_ambient_colour;
	uniform vec4   surface_diffuse_colour;
	uniform vec4   light_ambient;
	uniform vec4   light_diffuse;
	uniform vec4   light_position;
#endif

#ifdef SPECULAR
	uniform sampler2D specular_map1;
	uniform vec4   camera_position;
	uniform vec4   light_specular;
	uniform float  shine;
	uniform float  specularMult;
#endif

#ifdef SHARPENING
	uniform float  sharpen;
#endif

#ifdef TWOTEXTURES
	uniform sampler2D color_map2;
	#ifdef SPECULAR
		uniform sampler2D specular_map2;
	#endif
	uniform vec4 blend;
#endif

#ifdef LEAVES
	uniform sampler2D threshold_map;
#endif


varying vec4 _colour;
varying vec4 _uv0;
#ifdef LEAVES
	varying vec4 _uv1;
#endif
#ifdef PERVERTEX
	varying vec4 _diffuse;
#else // PERPIXEL
	varying vec3 _world_normal;
	varying vec3 _world_position;
#endif

void main()
{
	vec4 result;
	vec4 color_diffuse;
	vec4 color_specular;
	
#ifdef TWOTEXTURES
	
	vec4 color_top;
	vec4 color_base;
	vec4 specular_top;
	vec4 specular_base;
	vec4 blend_ = blend;
	
	color_base =    texture2D(color_map1,    _uv0.xy);
	color_top =     texture2D(color_map2,    _uv0.xy);
	
	#ifdef SHARPENING
		color_base -=   texture2D(color_map1,    _uv0.xy + 0.0001) * sharpen;
		color_base +=   texture2D(color_map1,    _uv0.xy - 0.0001) * sharpen;
		color_top -=    texture2D(color_map2,    _uv0.xy + 0.0001) * sharpen;
		color_top +=    texture2D(color_map2,    _uv0.xy - 0.0001) * sharpen;
	#endif
	
	#ifdef SPECULAR
		specular_base = texture2D(specular_map1, _uv0.xy);
		specular_top =  texture2D(specular_map2, _uv0.xy);
	#endif
	
	#ifdef LEAVES
		blend_.x = texture2D(threshold_map, _uv1.xy).x;
	#endif
	
	color_diffuse =  mix(color_base,    color_top,    blend_.x);
	
	#ifdef SPECULAR
		color_specular = mix(specular_base, specular_top, blend_.x);
	#endif
	
#else // ONETEXTURE

	color_diffuse =  texture2D(color_map1, _uv0.xy);
	
	#ifdef SHARPENING
	     color_diffuse -= texture2D(color_map1, _uv0.xy + 0.0001) * sharpen;
	     color_diffuse += texture2D(color_map1, _uv0.xy - 0.0001) * sharpen;
	#endif
	
	#ifdef SPECULAR
	     color_specular = texture2D(specular_map1, _uv0.xy);
	#endif
	
#endif

#ifndef GL_ES
	// znasilni barevnou slozku textury
	color_diffuse.rgb = clamp(color_diffuse.rgb * 1.1 - 0.05, 0.0, 1.0);
#endif
	
#ifdef PERVERTEX
	
	#ifdef TREELEAVES
		result.rgb = color_diffuse.rgb * _diffuse.rgb * _colour.rgb;
		result.a = color_diffuse.a * _diffuse.a;
	#else
		result = color_diffuse * _diffuse * _colour;
	#endif
	
#else // PERPIXEL

	vec4 lighting;
	vec3 camera_direction;
	vec3 light_direction;
	vec3 halfVec;
	vec3 specular;
	vec3 diffuse;
	float depth;
	
	light_direction = light_position.xyz - (_world_position.xyz * light_position.w);

	#ifdef SPECULAR
		camera_direction = camera_position.xyz - _world_position.xyz;
		depth = length(camera_direction);
		camera_direction /= depth;
		halfVec = normalize(light_position.xyz + camera_direction);
		
		lighting = lit(dot(light_direction.xyz, _world_normal.xyz), dot(halfVec, _world_normal.xyz), shine);
	#else
		lighting = lit(dot(light_direction.xyz, _world_normal.xyz), 0.0, 0.0);
	#endif
	
	// trochu znasilni difuzni cast osvetleni
	lighting.y = lighting.y * 1.1 - 0.05;
	
	diffuse  = lighting.y * light_diffuse.rgb;
	
	result.rgb = (color_diffuse.rgb * _colour.rgb * min(light_ambient.rgb * surface_ambient_colour.rgb + diffuse, vec3(1.0)));
	result.a = color_diffuse.a * surface_diffuse_colour.a;
	
	#ifdef SPECULAR
		result.rgb += lighting.z * light_specular.rgb * color_specular.rgb * specularMult;
	#endif
	
	#ifndef TREELEAVES
		result.a *= _colour.a;
	#endif
	
#endif
	
	gl_FragColor = result;
	
#ifdef ALPHA_REJECTION
	if (gl_FragColor.a < ALPHA_REJECTION)
		discard;
#endif
}

