#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform   vec4 world_3x4_array[240];
uniform   mat4 view_proj;

attribute vec4 vertex;
attribute vec4 colour;
attribute vec4 uv0;

varying   vec4 _colour;
varying   vec4 _uv0;

void main()
{
	// transform by indexed matrix
	// perform matrix multiplication manually since no 3x4 matrices
	vec3 _position;
	int index = int(uv0.x) * 3;
	for (int row = 0; row < 3; ++row)
	{
		vec4 matrix_row = world_3x4_array[index + row];
		_position[row] = dot(matrix_row, vertex);
	}
	
	_uv0.xy = uv0.xy;
	
	if (index <= 5)
		_colour = vec4(float(index) / 5.0, 0.0, 0.0, 1.0);
	else if (index <= 10)
		_colour = vec4(0.0, (float(index) - 5.0) / 5.0, 0.0, 1.0);
	else if (index <= 15)
		_colour = vec4(0.0, 0.0, (float(index) - 10.0) / 5.0, 1.0);
	else if (index <= 20)
		_colour = vec4(0.0, (float(index) - 15.0) / 5.0, (float(index) - 15.0) / 5.0, 1.0);
	else if (index <= 25)
		_colour = vec4((float(index) - 20.0) / 5.0, 0, (float(index) - 20.0) / 5.0, 1.0);
	else if (index <= 30)
		_colour = vec4((float(index) - 25.0) / 5.0, (float(index) - 25.0) / 5.0, 0.0, 1.0);
	
	gl_Position = view_proj * vec4(_position, 1);
}
