#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform vec4      shadow_color;
uniform sampler2D color_map1;

varying vec4      _colour;
varying vec4      _uv0;

void main()
{
	vec4 bitmap;
	vec3 character;
	vec3 shadow;
	
	bitmap =  texture2D(color_map1, _uv0.xy);
	// bitmap.r - character area
	// bitmap.g - shadow area (1 - bitmap.r)
	// bitmap.b - character + shadow alpha
	
	character = bitmap.r * _colour.rgb;
	shadow = bitmap.g * shadow_color.rgb;
	
	gl_FragColor = vec4(shadow.rgb + character.rgb, _colour.a * bitmap.a);
}
