#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform mat4 world_view_proj;

attribute vec4 vertex;
attribute vec4 colour;
attribute vec4 uv0;
attribute vec4 uv1;

varying   vec4 _colour;
varying   vec4 _uv0;
varying   vec4 _uv1;

void main()
{
	_colour = colour;
	_uv0.xy = uv0.xy;
	_uv1.xy = uv1.xy * 3.0;
	
	gl_Position = world_view_proj * vertex;
}

